<?php

$URL_BASE = 'https://secure.simple.com.au/clients/stanley/';

function getParam($label) { return isset($_REQUEST[$label]) ? $_REQUEST[$label] : ''; }

$variant = getParam('variant');

$name = getParam('name');
$position = getParam('position');

$mobile = getParam('mobile');
$address = getParam('address');


define('COLOUR_BLACK', '#493529');


define(LINK_STYLE, 'color: ' . COLOUR_BLACK . '; text-decoration: underline;');


if(strlen($mobile) > 0) $mobile_href = '+61' . preg_replace('~^0~', '', preg_replace('~\D~', '', $mobile));

if(strlen($address) == 0) $address = '93 Carrington Street Adelaide SA 5000';

function parse_link($url, $text) {
	?><a href="<?= $url ?>" style="<?= LINK_STYLE ?>"><span style="<?= LINK_STYLE ?>"><font style="<?= LINK_STYLE ?>"><?= $text ?></font></span></a><?php ;
}


?><!doctype html>
<html>

<head>
	<title>Email Signature Generator</title>
	
	<style type="text/css">
		html, input, .button, select { font: 16px/1.4 Sans-Serif; }
		
		body { padding: 20px; }
		
		h1 {
			font-size: 2rem;
			font-weight: bold;
			text-align: center;
			color: #231f20;
			margin: 0 0 1em;
		}
		
		form {
			width: 480px;
			padding: 1.5em;
			background-color: #eee;
		}
		
		form * { box-sizing: border-box; }
		
		form .wrapper {
			display: block;
			overflow: hidden;
			margin-bottom: 1em;
		}
		
		form input, form select {
			width: 100%;
			border: 2px solid gray;
			border-top: 0;
			border-radius: 0;
			padding: 0.5em 0.75em;
			margin: 0;
			
			background: none;
			outline: 0;
		}
		
		form input:focus, form textarea:focus { border-color: #231f20; }
		
		form .label {
			display: block;
			background-color: #231f20;
			padding: 0.5em;
			color: white;
		}
		
		form textarea {
			display: block;
			resize: vertical;
		}
		
		form .radio { padding: 1em 0; }
		
		form select { -webkit-appearance: none; }
		
		hr {
			margin: 2em 0;
			border: 1px solid #bebebe;
		}
		
		.button {
			font-weight: bold;
			color: #231f20;

			display: inline-block;
			padding: 0.5em 0.75em;
			border: 2px solid #231f20;

			cursor: pointer;
			background: transparent;
			transition: background 0.5s;
		}
		
		.button:not(:first-child) { margin-left: 2em; }
		
		.button:hover, .button:focus { background: white; }
		
		.instructions {
			font-size: 12px;
			padding-left: 1em;
		}
	</style>

	<script>
		document.addEventListener("DOMContentLoaded", function() {
			var copy_button = document.querySelector(".js-copy");
			
			if(copy_button != null) {
				copy_button.addEventListener("click", function() {
					var selection = document.getSelection();

					selection.removeAllRanges();
					selection.selectAllChildren(document.querySelector(".signature-wrapper"));

					document.execCommand("Copy");

					selection.empty();
				});
			}
		});
	</script>
</head>

<body>
	
	
	<form method="post">
		<h1>Email Signature Generator</h1>
		
		<label class="wrapper">
			<div class="label">Name *</div>
			
			<input type="text" name="name" required autofocus value="<?= $name ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Position *</div>
			
			<input type="text" name="position" required value="<?= $position ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Mobile *</div>
			
			<input type="text" name="mobile" required value="<?= $mobile ?>" placeholder="04xx xxx xxx">
		</label>
		
		
		<label class="wrapper">
			<div class="label">Address *</div>
			
			<input type="text" name="address" required value="<?= $address ?>">
		</label>
		
		<div class="wrapper">
			<button type="submit" class="button">Generate</button>
			
			<?php if(count($_POST) > 0): ?>
				<button type="button" class="button  js-copy">Copy</button>
			<?php endif; ?>
		</div>
	</form>
	
	
	<?php if(count($_POST) > 0): ?>
		<hr>
		
		<div class="signature-wrapper">
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" style="width: 300px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;" width="300">
				<tr>
					<td colspan="5" style="font-family: 'Times New Roman', serif; font-size: 16px; line-height: 1; color: #493529; vertical-align: top; padding-bottom: 36px;">
						<span style="color: #493529; text-decoration: none; letter-spacing: -0.4px;><font style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><?= $name ?></font></span><br>
						
						<span style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><font style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><?= $position ?></font></span><br>
						
					</td>
				</tr>
				
				<tr>
					<td colspan="5" style="font-family: 'Times New Roman', serif; font-size: 16px; line-height: 1; color: #493529; vertical-align: top; padding-bottom: 34px;">
						<a href="https://www.stanlaw.com.au" target="_blank" style="padding-bottom: 10px; color: #493529; text-decoration: none; letter-spacing: -0.4px;"><span style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><font style="color: #493529; text-decoration: none; letter-spacing: -0.4px;">
							
							<img src="<?= $URL_BASE ?>logo.png" style="width: 220px; border: 0; outline: none; text-decoration: none; height: auto;" width="220px" height="auto">
							
						</font></span></a>
					
					</td>
				</tr>

				<tr>
				<td colspan="5" style="font-family: 'Times New Roman', serif; font-size: 16px; line-height: 1; color: #493529; vertical-align: top; padding-bottom: 28px;">
						<span style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><font style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><?= $address ?></font></span><br>

						<?php if(strlen($mobile) > 0): ?>
							<span style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><font style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><?= $mobile ?></font></span><br>
						<?php endif; ?>

						<span style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><font style="color: #493529; text-decoration: none; letter-spacing: -0.4px;">08 7001 6135</font></span><br>

						<a href="mailto:<?= $email ?>" style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><span style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><font style="color: #493529; text-decoration: none; letter-spacing: -0.4px;"><?= $email ?></font></span></a>
						
						<br>
						<span style="color: #493529; text-decoration: none; font-family: 'Times New Roman', serif; font-size: 16px; line-height: 1;">
							<?= parse_link('https://stanlaw.com.au/', 'stanlaw.com.au') ?><br>
						</span>
						
						
					</td>
				</tr>
				
			
			</table>
		</div>
	<?php endif; ?>
</body>

</html>
