<?php

$URL_BASE = 'https://secure.simple.com.au/clients/sa-dental/';

function getParam($label) { return isset($_REQUEST[$label]) ? $_REQUEST[$label] : ''; }

$name = getParam('name');
$position = getParam('position');
$office = getParam('office');
$phone = getParam('phone');
$mobile = getParam('mobile');
$facsimile = getParam('facsimile');
$email = getParam('email');
$image = getParam('image');

if(strlen($phone) > 0) {
	$phone_href = preg_replace('~\D~', '', $phone);
	
	if(strlen($phone_href) == 8) {
		$phone = '08 ' . $phone;
		$phone_href = '08' . $phone_href;
	}
	
	$phone_href = '+61' . preg_replace('~^0~', '', $phone_href);
}

if(strlen($facsimile) > 0) {
	$facsimile_href = preg_replace('~\D~', '', $facsimile);
	
	if(strlen($facsimile_href) == 8) {
		$facsimile = '08 ' . $facsimile;
		$facsimile_href = '08' . $facsimile_href;
	}
	
	$facsimile_href = '+61' . preg_replace('~^0~', '', $facsimile_href);
}

if(strlen($mobile) > 0) $mobile_href = '+61' . preg_replace('~^0~', '', preg_replace('~\D~', '', $mobile));


if(strlen($image) == 0) $image = 'option-1';

$image_top_margin = 40;
if($image == 'option-1') $image_top_margin = 20;



?><!doctype html>
<html>

<head>
	<title>Email Signature Generator</title>
	
	<style type="text/css">
		html, input, .button, select { font: 16px/1.4 Sans-Serif; }
		
		body { padding: 20px; }
		
		h1 {
			font-size: 2rem;
			font-weight: bold;
			text-align: center;
			color: #231f20;
			margin: 0 0 1em;
		}
		
		form {
			width: 480px;
			padding: 1.5em;
			background-color: #eee;
		}
		
		form * { box-sizing: border-box; }
		
		form .wrapper {
			display: block;
			overflow: hidden;
			margin-bottom: 1em;
		}
		
		form input, form select {
			width: 100%;
			border: 2px solid gray;
			border-top: 0;
			border-radius: 0;
			padding: 0.5em 0.75em;
			margin: 0;
			
			background: none;
			outline: 0;
		}
		
		form input:focus, form textarea:focus { border-color: #231f20; }
		
		form .label {
			display: block;
			background-color: #231f20;
			padding: 0.5em;
			color: white;
		}
		
		form textarea {
			display: block;
			resize: vertical;
		}
		
		form .radio { padding: 1em 0; }
		
		form select { -webkit-appearance: none; }
		
		hr {
			margin: 2em 0;
			border: 1px solid #bebebe;
		}
		
		.button {
			font-weight: bold;
			color: #231f20;

			display: inline-block;
			padding: 0.5em 0.75em;
			border: 2px solid #231f20;

			cursor: pointer;
			background: transparent;
			transition: background 0.5s;
		}
		
		.button:not(:first-child) { margin-left: 2em; }
		
		.button:hover, .button:focus { background: white; }
		
		.instructions {
			font-size: 12px;
			padding-left: 1em;
		}
	</style>

	<script>
		document.addEventListener("DOMContentLoaded", function() {
			var copy_button = document.querySelector(".js-copy");
			
			if(copy_button != null) {
				copy_button.addEventListener("click", function() {
					var selection = document.getSelection();

					selection.removeAllRanges();
					selection.selectAllChildren(document.querySelector(".signature-wrapper"));

					document.execCommand("Copy");

					selection.empty();
				});
			}
		});
	</script>
</head>

<body>
	<form method="post">
		<h1>Email Signature Generator</h1>
		
		<label class="wrapper">
			<div class="label">Name *</div>
			
			<input type="text" name="name" required autofocus value="<?= $name ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Position *</div>
			
			<input type="text" name="position" required value="<?= $position ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Office / Clinic *</div>
			
			<input type="text" name="office" required value="<?= $office ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Phone *</div>
			
			<input type="text" name="phone" required value="<?= $phone ?>" placeholder="08 8000 0000">
		</label>
		
		<label class="wrapper">
			<div class="label">Mobile</div>
			
			<input type="text" name="mobile" value="<?= $mobile ?>" placeholder="0400 000 000">
		</label>
		
		<label class="wrapper">
			<div class="label">Facsimile</div>
			
			<input type="text" name="facsimile" value="<?= $facsimile ?>" placeholder="08 8000 0000">
		</label>
		
		<label class="wrapper">
			<div class="label">Email *</div>
			
			<input type="email" name="email" required value="<?= $email ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Footer Image *</div>
			
			<select name="image" required>
				<option value="option-1"<?php if($image == 'option-1'): ?> selected<? endif; ?>>With Character</option>
				<option value="option-2"<?php if($image == 'option-2'): ?> selected<? endif; ?>>Without Character</option>
			</select>
		</label>
		
		<div class="wrapper">
			<button type="submit" class="button">Generate</button>
			
			<?php if(count($_POST) > 0): ?>
				<button type="button" class="button  js-copy">Copy</button>
			<?php endif; ?>
		</div>
	</form>
	
	
	<?php if(count($_POST) > 0): ?>
		<hr>
		
		<div class="signature-wrapper">
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" style="width: 540px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;" width="540px">
				<tr>
					<td colspan="4" style="font-family: Helvetica, Arial, sans-serif; font-size: 14px; line-height: 18px; color: #2526a9; vertical-align: top;">
						<a style="color: #2526a9; text-decoration: none; font-weight: bold;"><span style="color: #2526a9; text-decoration: none; font-weight: bold;"><font style="color: #2526a9; text-decoration: none; font-weight: bold;"><?= $name ?></font></span></a><br>
						
						<a style="color: #2526a9; text-decoration: none; font-weight: bold;"><span style="color: #2526a9; text-decoration: none; font-weight: bold;"><font style="color: #2526a9; text-decoration: none; font-weight: bold;"><?= $position ?></font></span></a><br>
						
						<a style="color: #2526a9; text-decoration: none;"><span style="color: #2526a9; text-decoration: none;"><font style="color: #2526a9; text-decoration: none;"></font></span><?= $office ?><br>SA Dental&nbsp;&nbsp;|&nbsp;&nbsp;Central Adelaide Local Health Network</a><br>
						
						<br><br>
					</td>
				</tr>
				
				
				<tr>
					<td colspan="2" width="88px" style="font-family: Helvetica, Arial, sans-serif; font-size: 14px; line-height: 18px; color: #2526a9; vertical-align: top; width: 88px; padding-bottom: 7px;">
						Telephone<br>
						<?php if(strlen($mobile) > 0): ?>Mobile<br><?php endif; ?>
						<?php if(strlen($facsimile) > 0): ?>Facsimile<br><?php endif; ?>
						Email<br>
						Website<br>
					</td>
					
					<td colspan="2" width="452px" style="font-family: Helvetica, Arial, sans-serif; font-size: 14px; line-height: 18px; color: #2526a9; vertical-align: top; padding-bottom: 7px; width: 452px;">
						<a href="tel:<?= $phone_href ?>" style="color: #2526a9; text-decoration: none;"><span style="color: #2526a9; text-decoration: none;"><font style="color: #2526a9; text-decoration: none;"><?= $phone ?></font></span></a><br>
						
						<?php if(strlen($mobile) > 0): ?>
							<a href="tel:<?= $mobile_href ?>" style="color: #2526a9; text-decoration: none;"><span style="color: #2526a9; text-decoration: none;"><font style="color: #2526a9; text-decoration: none;"><?= $mobile ?></font></span></a><br>
						<?php endif; ?>
						
						<?php if(strlen($facsimile) > 0): ?>
							<a href="tel:<?= $facsimile_href ?>" style="color: #2526a9; text-decoration: none;"><span style="color: #2526a9; text-decoration: none;"><font style="color: #2526a9; text-decoration: none;"><?= $facsimile ?></font></span></a><br>
						<?php endif; ?>
						
						<a href="mailto:<?= $email ?>" style="color: #2526a9; text-decoration: none;"><span style="color: #2526a9; text-decoration: none;"><font style="color: #2526a9; text-decoration: none;"><?= $email ?></font></span></a><br>
						
						<a href="http://sadental.sa.gov.au/" target="_blank" style="color: #2526a9; text-decoration: none;"><span style="color: #2526a9; text-decoration: none;"><font style="color: #2526a9; text-decoration: none;">sadental.sa.gov.au</font></span></a><br>
					</td>
				</tr>
				
				
				<tr>
					<td width="36px" style="font-family: Helvetica, Arial, sans-serif; font-size: 14px; line-height: 18px; color: #2526a9; vertical-align: top; width: 36px; padding-bottom: <?= $image_top_margin ?>px;">
						<a href="https://www.facebook.com/SADentalService" target="_blank" style="color: #2526a9; text-decoration: none;"><span style="color: #2526a9; text-decoration: none;"><font style="color: #2526a9; text-decoration: none;">
							<img src="<?= $URL_BASE ?>facebook.png" style="width: 32x; border: 0; outline: none; text-decoration: none; height: auto;" width="32" height="auto">
						</font></span></a>
					</td>
					
					<td width="36px" style="font-family: Helvetica, Arial, sans-serif; font-size: 14px; line-height: 18px; color: #2526a9; vertical-align: top; width: 36px; padding-bottom: <?= $image_top_margin ?>px; padding-left: 8px; padding-right: 8px;">
						<a href="https://www.instagram.com/sadental_/" target="_blank" style="color: #2526a9; text-decoration: none;"><span style="color: #2526a9; text-decoration: none;"><font style="color: #2526a9; text-decoration: none;">
							<img src="<?= $URL_BASE ?>instagram.png" style="width: 32px; border: 0; outline: none; text-decoration: none; height: auto;" width="32" height="auto">
						</font></span></a>
					</td>
					
					
					<td width="36px" style="font-family: Helvetica, Arial, sans-serif; font-size: 14px; line-height: 18px; color: #2526a9; vertical-align: top; width: 36px; padding-bottom: <?= $image_top_margin ?>px;">
						<a href="https://www.linkedin.com/company/sa-dental/" target="_blank" style="color: #2526a9; text-decoration: none;"><span style="color: #2526a9; text-decoration: none;"><font style="color: #2526a9; text-decoration: none;">
							<img src="<?= $URL_BASE ?>linkedin.png" style="width: 32x; border: 0; outline: none; text-decoration: none; height: auto;" width="32" height="auto">
						</font></span></a>
					</td>
					
					
					<td width="416px" style="font-family: Helvetica, Arial, sans-serif; font-size: 14px; line-height: 18px; color: #2526a9; vertical-align: top; padding-bottom: <?= $image_top_margin ?>px; width: 432px;">&nbsp;</td>
				</tr>
				
				<tr>
					<td colspan="4" style="font-family: Helvetica, Arial, sans-serif; font-size: 14px; line-height: 18px; color: #2526a9; vertical-align: top; padding-bottom: 16px;">
						<?php if($image == 'option-1'): ?>
							<img src="<?= $URL_BASE ?>option-1.png" style="width: 527px; border: 0; outline: none; text-decoration: none; height: auto;" width="527" height="auto">
							
						<?php else: ?>
							<img src="<?= $URL_BASE ?>option-2.png" style="width: 500px; border: 0; outline: none; text-decoration: none; height: auto;" width="500" height="auto">
							
						<?php endif; ?>
					</td>
				</tr>
				
				<tr>
					<td colspan="4" style="font-family: Helvetica, Arial, sans-serif; font-style: italic; font-size: 12px; line-height: 12px; color: #afafaf; vertical-align: top;">
						<p style="width: 500px; padding-top: 12px; border-top: 1px solid #ffafcd; margin: 0;">This email may contain confidential information, which also may be legally privileged. Only the intended recipient(s) may access, use, distribute or copy this email. If this email is received in error, please inform the sender by return email and delete the original. If there are doubts about the validity of this message, please contact the sender by telephone. It is the recipient’s responsibility to check the email and any attached files for viruses.</p>
					</td>
				</tr>
			</table>
		</div>
	<?php endif; ?>
</body>

</html>
