<?php

$URL_BASE = 'https://secure.simple.com.au/clients/rundle/';

function getParam($label) { return isset($_REQUEST[$label]) ? $_REQUEST[$label] : ''; }

$variant = getParam('variant');

$name = getParam('name');
$position = getParam('position');
$availability = getParam('availability');
$phone = getParam('phone');
$mobile = getParam('mobile');
$email = getParam('email');



if(strlen($availability) > 0) $availability_text = ' | ' . $availability;

if(strlen($phone) > 0) {
	$phone_href = preg_replace('~\D~', '', $phone);
	
	if(strlen($phone_href) == 8) {
		$phone = '08 ' . $phone;
		$phone_href = '08' . $phone_href;
	}
	
	$phone_href = '+61' . preg_replace('~^0~', '', $phone_href);
}

if(strlen($mobile) > 0) $mobile_href = '+61' . preg_replace('~^0~', '', preg_replace('~\D~', '', $mobile));


?><!doctype html>
<html>

<head>
	<title>Email Signature Generator</title>
	
	<style type="text/css">
		html, input, .button, select { font: 16px/1.4 Sans-Serif; }
		
		body { padding: 20px; }
		
		h1 {
			font-size: 2rem;
			font-weight: bold;
			text-align: center;
			color: #231f20;
			margin: 0 0 1em;
		}
		
		form {
			width: 480px;
			padding: 1.5em;
			background-color: #eee;
		}
		
		form * { box-sizing: border-box; }
		
		form .wrapper {
			display: block;
			overflow: hidden;
			margin-bottom: 1em;
		}
		
		form input, form select {
			width: 100%;
			border: 2px solid gray;
			border-top: 0;
			border-radius: 0;
			padding: 0.5em 0.75em;
			margin: 0;
			
			background: none;
			outline: 0;
		}
		
		form input:focus, form textarea:focus { border-color: #231f20; }
		
		form .label {
			display: block;
			background-color: #231f20;
			padding: 0.5em;
			color: white;
		}
		
		form textarea {
			display: block;
			resize: vertical;
		}
		
		form .radio { padding: 1em 0; }
		
		form select { -webkit-appearance: none; }
		
		hr {
			margin: 2em 0;
			border: 1px solid #bebebe;
		}
		
		.button {
			font-weight: bold;
			color: #231f20;

			display: inline-block;
			padding: 0.5em 0.75em;
			border: 2px solid #231f20;

			cursor: pointer;
			background: transparent;
			transition: background 0.5s;
		}
		
		.button:not(:first-child) { margin-left: 2em; }
		
		.button:hover, .button:focus { background: white; }
		
		.instructions {
			font-size: 12px;
			padding-left: 1em;
		}
	</style>

	<script>
		document.addEventListener("DOMContentLoaded", function() {
			var copy_button = document.querySelector(".js-copy");
			
			if(copy_button != null) {
				copy_button.addEventListener("click", function() {
					var selection = document.getSelection();

					selection.removeAllRanges();
					selection.selectAllChildren(document.querySelector(".signature-wrapper"));

					document.execCommand("Copy");

					selection.empty();
				});
			}
		});
	</script>
</head>

<body>
	<a href="https://secure.simple.com.au/clients/rundle/generator.php">Standard</a><br>
	<a href="https://secure.simple.com.au/clients/rundle/generator.php?variant=christmas">Christmas</a><br>
	<a href="https://secure.simple.com.au/clients/rundle/generator.php?variant=2020">2020</a><br>
	<a href="https://secure.simple.com.au/clients/rundle/generator.php?variant=festive-2020">2020 - Festive Season</a><br>
	<a href="https://secure.simple.com.au/clients/rundle/generator.php?variant=generic-march-2020">Generic - March 2020</a><br>
	<a href="https://secure.simple.com.au/clients/rundle/generator.php?variant=generic-july-2020">Generic - July 2020</a><br>
	<a href="https://secure.simple.com.au/clients/rundle/generator.php?variant=spring-2020">Spring 2020</a><br>
	<br>
	
	<form method="post">
		<h1>Email Signature Generator</h1>
		
		<label class="wrapper">
			<div class="label">Name *</div>
			
			<input type="text" name="name" required autofocus value="<?= $name ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Position *</div>
			
			<input type="text" name="position" required value="<?= $position ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">
				Availability<br>
				
				<div class="instructions">
					Please format your working hours as below;<br>
					Monday, Tuesday &amp; Thursday<br>
					Monday &amp; Thursday &ndash; 8:30am &ndash; 5:30pm
				</div>
			</div>
			
			<input type="text" name="availability" value="<?= $availability ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Email *</div>
			
			<input type="email" name="email" required value="<?= $email ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Mobile</div>
			
			<input type="text" name="mobile" value="<?= $mobile ?>" placeholder="04xx xxx xxx">
		</label>
		
		<label class="wrapper">
			<div class="label">Phone *</div>
			
			<input type="text" name="phone" required value="<?= $phone ?>" placeholder="08 xxxx xxxx">
		</label>
		
		<div class="wrapper">
			<button type="submit" class="button">Generate</button>
			
			<?php if(count($_POST) > 0): ?>
				<button type="button" class="button  js-copy">Copy</button>
			<?php endif; ?>
		</div>
	</form>
	
	
	<?php if(count($_POST) > 0): ?>
		<hr>
		
		<div class="signature-wrapper">
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" style="width: 450px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;" width="450">
				<tr>
					<td colspan="5" style="font-family: Arial; font-size: 14px; line-height: 1.2; color: #58585a; vertical-align: top; padding-bottom: 28px;">
						<a style="color: #58585a; text-decoration: none; font-weight: bold;"><span style="color: #58585a; text-decoration: none; font-weight: bold;"><font style="color: #58585a; text-decoration: none; font-weight: bold;"><?= $name ?></font></span></a><br>
						
						<a style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;"><?= $position ?><?= $availability_text ?></font></span></a><br>
						
						<br>
						
						<a href="mailto:<?= $email ?>" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;"><?= $email ?></font></span></a><br>
						
						<?php if(strlen($mobile) > 0): ?>
							<a href="<?= $mobile_href ?>" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">Mob <?= $mobile ?></font></span></a><br>
						<?php endif; ?>
						
						<a href="<?= $phone_href ?>" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">Tel <?= $phone ?></font></span></a><br>
						
						<br>
						
						<a style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">Level 2, 7 James Place Adelaide SA 5000</font></span></a><br>
						
						<a href="https://rundlemall.com" target="_blank" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">rundlemall.com</font></span></a><br>
					</td>
				</tr>
				
				
				<tr>
					<td style="font-family: Arial; font-size: 14px; line-height: 20px; color: #58585a; vertical-align: top; width: 24px; padding-bottom: 28px;">
						<a href="https://www.facebook.com/rundlemallSA" target="_blank" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">
							<img src="<?= $URL_BASE ?>facebook.png" style="width: 19x; border: 0; outline: none; text-decoration: none; height: auto;" width="19" height="auto">
						</font></span></a>
					</td>
					
					<td style="font-family: Arial; font-size: 14px; line-height: 20px; color: #58585a; vertical-align: top; width: 100px; padding-bottom: 28px;">
						<a href="https://www.facebook.com/rundlemallSA" target="_blank" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">/rundlemallSA</font></span></a>
					</td>
					
					<td style="font-family: Arial; font-size: 14px; line-height: 20px; color: #58585a; vertical-align: top; width: 24px; padding-bottom: 28px;">
						<a href="https://www.instagram.com/rundlemall" target="_blank" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">
							<img src="<?= $URL_BASE ?>instagram.png" style="width: 20px; border: 0; outline: none; text-decoration: none; height: auto;" width="20" height="auto">
						</font></span></a>
					</td>
					
					<td style="font-family: Arial; font-size: 14px; line-height: 20px; color: #58585a; vertical-align: top; width: 100px; padding-bottom: 28px;">
						<a href="https://www.instagram.com/rundlemall" target="_blank" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">@rundlemall</font></span></a>
					</td>
					
					<td style="font-family: Arial; font-size: 14px; line-height: 20px; color: #58585a; vertical-align: top; width: 202px; padding-bottom: 28px;"></td>
				</tr>
				
				
				
				<tr>
					<td colspan="5" style="font-family: Arial; font-size: 14px; line-height: 1.2; color: #58585a; vertical-align: top; padding-bottom: 28px;">
					
					<?php if($variant == 'spring-2020'): ?>
							<a href="https://rundlemall.com/win" target="_blank" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">
								<img src="<?= $URL_BASE ?>spring-2020.jpg" style="width: 450px; border: 0; outline: none; text-decoration: none; height: auto;" width="450" height="auto">
							</font></span></a>
					<?php else: ?>
						<a href="https://rundlemall.com" target="_blank" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">
							<?php if($variant == 'festive-2020'): ?>
								<img src="<?= $URL_BASE ?>festive-banner.jpeg" style="width: 450px; border: 0; outline: none; text-decoration: none; height: auto;" width="450" height="auto">
							
							<?php elseif($variant == 'christmas'): ?>
								<img src="<?= $URL_BASE ?>christmas.png" style="width: 450px; border: 0; outline: none; text-decoration: none; height: auto;" width="450" height="auto">
								
							<?php elseif($variant == '2020'): ?>
								<img src="<?= $URL_BASE ?>2020-banner.png" style="width: 450px; border: 0; outline: none; text-decoration: none; height: auto;" width="450" height="auto">
								
							<?php elseif($variant == 'generic-march-2020'): ?>
								<img src="<?= $URL_BASE ?>generic-march-2020.png" style="width: 450px; border: 0; outline: none; text-decoration: none; height: auto;" width="450" height="auto">

							<?php elseif($variant == 'generic-july-2020'): ?>
								<img src="<?= $URL_BASE ?>generic-july-2020.png" style="width: 450px; border: 0; outline: none; text-decoration: none; height: auto;" width="450" height="auto">
								
							<?php else: ?>
								<img src="<?= $URL_BASE ?>logo.png" style="width: 140px; border: 0; outline: none; text-decoration: none; height: auto;" width="140" height="auto">
								
							<?php endif; ?>
						</font></span></a>
						<?php endif; ?>
					</td>
				</tr>
				
				
				<tr>
					<td colspan="5" style="font-family: Arial; font-size: 11px; line-height: 1.2; color: #969696; vertical-align: top; padding-bottom: 28px;">
						<a style="color: #969696; text-decoration: none;"><span style="color: #969696; text-decoration: none;"><font style="color: #969696; text-decoration: none;">	The contents of this e-mail are confidential and may be subject to privilege and copyright. This e-mail is intended for the named recipient only and if you have received this e-mail in error please notify the City of Adelaide immediately on +61(8) 8203 7203. The views expressed in this e-mail are, unless otherwise stated, those of the author and do not reflect the views, policy or position of the City of Adelaide and the City of Adelaide accepts no responsibility for any such opinions, advice or information.</font></span></a>
					</td>
				</tr>
			</table>
		</div>
	<?php endif; ?>
</body>

</html>
