<?php

define('URL_BASE', 'https://secure.simple.com.au/clients/penley/');

define('COLOUR_BLACK', '#161616');


define(LINK_STYLE, 'color: ' . COLOUR_BLACK . '; text-decoration: none;');


function parse_link($url, $text) {
	?><a href="<?= $url ?>" style="<?= LINK_STYLE ?>"><span style="<?= LINK_STYLE ?>"><font style="<?= LINK_STYLE ?>"><?= $text ?></font></span></a><?php ;
}

function get_param($label) { return isset($_REQUEST[$label]) ? $_REQUEST[$label] : ''; }



$name = get_param('name');
$pronouns = get_param('pronouns');
$position = get_param('position');

$mobile = get_param('mobile');
if(strlen($mobile) > 0) $mobile_href = 'tel:+61' . preg_replace('~(^0|\D)~', '', $mobile);

$email = get_param('email');

$address = get_param('address');

// https://secure.simple.com.au/clients/penley/generator.php?name=Erin+Fields&pronouns=she%2Fher&position=Brand+Comms+Manager&mobile=0413+411+852&email=erin.fields%40penley.com.au&address=276+California+Road%2C%0D%0AMcLaren+Vale+SA+5171

?><!doctype html>
<html>

<head>
	<title>Email Signature Generator</title>
	
	<style type="text/css">
		html, input, .button, select, textarea { font: 16px/1.4 Sans-Serif; }
		
		body { padding: 20px; }
		
		h1 {
			font-size: 2rem;
			font-weight: bold;
			text-align: center;
			color: #231f20;
			margin: 0 0 1em;
		}
		
		form {
			width: 480px;
			padding: 1.5em;
			background-color: #eee;
		}
		
		form * { box-sizing: border-box; }
		
		form .wrapper {
			display: block;
			overflow: hidden;
			margin-bottom: 1em;
		}
		
		form input, form select, form textarea {
			width: 100%;
			border: 2px solid gray;
			border-top: 0;
			border-radius: 0;
			padding: 0.5em 0.75em;
			margin: 0;
			
			background: none;
			outline: 0;
		}
		
		form input:focus, form textarea:focus { border-color: #231f20; }
		
		form .label {
			display: block;
			background-color: #231f20;
			padding: 0.5em;
			color: white;
		}
		
		form textarea {
			display: block;
			resize: vertical;
		}
		
		form .radio { padding: 1em 0; }
		
		form select { -webkit-appearance: none; }
		
		hr {
			margin: 2em 0;
			border: 1px solid #bebebe;
		}
		
		.button {
			font-weight: bold;
			color: #231f20;

			display: inline-block;
			padding: 0.5em 0.75em;
			border: 2px solid #231f20;

			cursor: pointer;
			background: transparent;
			transition: background 0.5s;
		}
		
		.button:not(:first-child) { margin-left: 2em; }
		
		.button:hover, .button:focus { background: white; }
		
		.instructions {
			font-size: 12px;
			padding-left: 1em;
		}
	</style>

	<script>
		document.addEventListener("DOMContentLoaded", function() {
			var copy_button = document.querySelector(".js-copy");
			
			if(copy_button != null) {
				copy_button.addEventListener("click", function() {
					var selection = document.getSelection();

					selection.removeAllRanges();
					selection.selectAllChildren(document.querySelector(".signature-wrapper"));

					document.execCommand("Copy");

					selection.empty();
				});
			}
		});
	</script>
</head>

<body>
	<form method="post">
		<h1>Email Signature Generator</h1>
		
		<label class="wrapper">
			<div class="label">Name *</div>
			
			<input type="text" name="name"value="<?= $name ?>" autofocus required>
		</label>
		
		<label class="wrapper">
			<div class="label">Pronouns *</div>
			
			<input type="text" name="pronouns" value="<?= $pronouns ?>" required>
		</label>
		
		<label class="wrapper">
			<div class="label">Position *</div>
			
			<input type="text" name="position" value="<?= $position ?>" required>
		</label>
		
		<label class="wrapper">
			<div class="label">Mobile * (syntax: 0400 000 000)</div>
			
			<input type="text" name="mobile" value="<?= $mobile ?>" required>
		</label>
		
		<label class="wrapper">
			<div class="label">Email *</div>
			
			<input type="email" name="email" value="<?= $email ?>" required>
		</label>
		
		<label class="wrapper">
			<div class="label">Address *</div>
			
			<textarea name="address" rows="4" required><?= $address ?></textarea>
		</label>
		
		
		<div class="wrapper">
			<button type="submit" class="button">Generate</button>
			
			<?php if(count($_REQUEST) > 0): ?>
				<button type="button" class="button  js-copy">Copy</button>
			<?php endif; ?>
		</div>
	</form>
	
	
	<?php if(count($_REQUEST) > 0): ?>
		<hr>
		
		<div class="signature-wrapper">
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" width="320" style="width: 320px; font-family: 'Times New Roman', serif; font-style: italic; font-size: 26px; mso-line-height-rule: exactly; line-height: 78.125%; letter-spacing: -0.08em; vertical-align: top; color: <?= COLOUR_BLACK ?>; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;">
				<tr>
					<td style="line-height: 100%;">
						<img src="<?= URL_BASE ?>logo.png" width="180" height="auto" style="width: 180px; height: auto; border: 0; outline: none; text-decoration: none;">
					</td>
				</tr>
				
				<tr>
					<td style="font-family: 'Times New Roman', serif;">
						<?= $name ?><br>
						(<?= $pronouns ?>)<br>
						<br>
						<?= $position ?><br>
						<?= parse_link($mobile_href, 'Mob &mdash; ' . $mobile) ?><br>
						<?= parse_link('mailto:' . $email, $email) ?><br>
						<br>
					</td>
				</tr>
				
				<tr>
					<td style="font-family: 'Times New Roman', serif; border-top: 1px solid <?= COLOUR_BLACK ?>; padding-top: 5px;">
						<?= parse_link('', nl2br($address)) ?><br>
						<?= parse_link('https://penley.com.au/', 'penley.com.au') ?><br>
						<br>
					</td>
				</tr>
				
				<tr>
					<td style="font-family: Arial, sans-serif; font-size: 12px; line-height: 16px; letter-spacing: -0.02em;">
						Penley Estate Pty Ltd<br>
						ABN 60 638 686 650 / Liquor Licence 50802753<br>
						<?= parse_link('mailto:penley@penley.com.au', 'penley@penley.com.au') ?> / <?= parse_link('https://penley.com.au/', 'penley.com.au') ?>
					</td>
				</tr>
			</table>
		</div>
	<?php endif; ?>
</body>

</html>
