<?php

// should be DEFINE?
$URL_BASE = 'https://secure.simple.com.au/clients/may-health/';


function gen_link($text, $url, $style) {
	?><a href="<?= $url ?>" style="<?= $style ?>"><span style="<?= $style ?>"><font style="<?= $style ?>"><?= $text ?></font></span></a><?php
}

function getParam($label) { return isset($_REQUEST[$label]) ? $_REQUEST[$label] : ''; }



$name = getParam('name');
$position = getParam('position');
$discipline = getParam('discipline');


?><!doctype html>
<html>

<head>
	<title>Email Signature Generator</title>
	
	<style type="text/css">
		html, input, .button, select { font: 16px/1.4 Sans-Serif; }
		
		body { padding: 20px; }
		
		h1 {
			font-size: 2rem;
			font-weight: bold;
			text-align: center;
			color: #231f20;
			margin: 0 0 1em;
		}
		
		form {
			width: 480px;
			padding: 1.5em;
			background-color: #eee;
		}
		
		form * { box-sizing: border-box; }
		
		form .wrapper {
			display: block;
			overflow: hidden;
			margin-bottom: 1em;
		}
		
		form input, form select {
			width: 100%;
			border: 2px solid gray;
			border-top: 0;
			border-radius: 0;
			padding: 0.5em 0.75em;
			margin: 0;
			
			background: none;
			outline: 0;
		}
		
		form input:focus, form textarea:focus { border-color: #231f20; }
		
		form .label {
			display: block;
			background-color: #231f20;
			padding: 0.5em;
			color: white;
		}
		
		form textarea {
			display: block;
			resize: vertical;
		}
		
		form .radio { padding: 1em 0; }
		
		form select { -webkit-appearance: none; }
		
		hr {
			margin: 2em 0;
			border: 1px solid #bebebe;
		}
		
		.button {
			font-weight: bold;
			color: #231f20;

			display: inline-block;
			padding: 0.5em 0.75em;
			border: 2px solid #231f20;

			cursor: pointer;
			background: transparent;
			transition: background 0.5s;
		}
		
		.button:not(:first-child) { margin-left: 2em; }
		
		.button:hover, .button:focus { background: white; }
		
		.instructions {
			font-size: 12px;
			padding-left: 1em;
		}
	</style>

	<script>
		document.addEventListener("DOMContentLoaded", function() {
			var copy_button = document.querySelector(".js-copy");
			
			if(copy_button != null) {
				copy_button.addEventListener("click", function() {
					var selection = document.getSelection();

					selection.removeAllRanges();
					selection.selectAllChildren(document.querySelector(".signature-wrapper"));

					document.execCommand("Copy");

					selection.empty();
				});
			}
		});
	</script>
</head>

<body>
	<form method="post">
		<h1>Email Signature Generator</h1>
		
		<label class="wrapper">
			<div class="label">Name *</div>
			
			<input type="text" name="name" required autofocus value="<?= $name ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Position *</div>
			
			<input type="text" name="position" required value="<?= $position ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Discipline *</div>
			
			<input type="text" name="discipline" required value="<?= $discipline ?>">
		</label>
		
		<div class="wrapper">
			<button type="submit" class="button">Generate</button>
			
			<?php if(count($_POST) > 0): ?>
				<button type="button" class="button  js-copy">Copy</button>
			<?php endif; ?>
		</div>
	</form>
	
	
	<?php if(count($_POST) > 0): ?>
		<hr>
		
		<div class="signature-wrapper">
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" style="width: 345px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;" width="345px">
				<tr>
					<td style="font-family: Arial, sans-serif; font-size: 16px; line-height: 21px; color: #696d75; vertical-align: top; padding-bottom: 25px;">
						<strong style="363a43"><?= $name ?></strong><br>
						<?= $position ?><br>
						<?= $discipline ?><br>
						<br>
						<?php gen_link('28 Ward Street', '', 'color: #696d75; text-decoration: none;'); ?><br>
						<?php gen_link('North Adelaide SA 5006', '', 'color: #696d75; text-decoration: none;'); ?><br>
						<?php gen_link('(08) 8267 5466', 'tel:+61882675466', 'color: #696d75; text-decoration: none;'); ?><br>
						<?php gen_link('mayhealth.com.au', 'https://mayhealth.com.au', 'color: #696d75; text-decoration: underline;'); ?><br>
					</td>
				</tr>
				
				<tr>
					<td style="font-family: Arial, sans-serif; font-size: 16px; line-height: 21px; color: #696d75; vertical-align: top; padding-bottom: 30px;">
						<img src="<?= $URL_BASE ?>logo.png" style="width: 217 x; border: 0; outline: none; text-decoration: none; height: auto;" width="217" height="auto">
					</td>
				</tr>
			</table>
		</div>
	<?php endif; ?>
</body>

</html>
