<?php

define('URL_BASE', 'https://secure.simple.com.au/clients/leedwell/');

define('COLOUR_BLACK', '#232526');
define('COLOUR_GREEN', '#82FF91');

define('LINK_STYLE', 'color: ' . COLOUR_BLACK . '; text-decoration: none;');


// built this way as doing otherwise isn't worth the hassle
function parse_link($url, $text) {
	return '<a href="' . $url . '" style="' . LINK_STYLE . '"><span style="' . LINK_STYLE . '"><font style="' . LINK_STYLE . '">' . $text . '</font></span></a>';
}

function get_param($label) { return isset($_REQUEST[$label]) ? $_REQUEST[$label] : ''; }



$name = get_param('name');
$position = get_param('position');
$mobile = get_param('mobile');
$office = get_param('office');
//$close = get_param('close');
$image = get_param('image');
$disclaimer = get_param('disclaimer');

if(strlen($mobile) > 0) {
	$mobile_href = '+' . preg_replace('~\D~', '', $mobile);
}


$office_phone = '';
$office_fax = '';
$office_address = '';
if($office == 'sa') {
	$office_phone = parse_link('tel:+61882128880', '+61 8 8212 8880');
	$office_fax = parse_link('tel:+61882128881', '+61 8 8212 8881');
	$office_address = '136 Greenhill Road<br>Unley SA 5061';
}

if($office == 'vic') {
	$office_phone = parse_link('tel:+61390896688', '+61 3 9089 6688');
	$office_address = 'G.05, 10 Garden Street,<br>South Yarra VIC 3141';
}





$disclaimer_text = '';
switch($disclaimer) {
	case 'sa':
		$disclaimer_text = 'RLA 222531

		Leedwell Property Pty Ltd trading as Leedwell Property (ABN 87 137 238 067). The information in this email including any attachments is intended solely for the named recipient. It may contain privileged and/or confidential information. If you are not the intended recipient, you must not disclose, copy, distribute, take any action or rely upon it. If you have received this email in error, please notify the sender immediately and delete this email. It is your responsibility to scan this transmission for the presence of viruses as it cannot be guaranteed to be secure or error free. The sender does not accept liability for any error or omission in the contents of this message. Leedwell Property respects your privacy. If you no longer wish to receive marketing material and other property information from Leedwell please advise us via email to <a href="mailto:info@leedwell.com.au">info@leedwell.com.au</a> including the name of the property and/or publication that you most recently received.
		
		Please read the <a href="https://www.cbs.sa.gov.au/sites/default/files/form-7-warning-notice.pdf?timestamp=1561592893776">CBS Form R7</a>. Under Legislative provisions we are required to serve this to you.';
		break;
	
	case 'vic':
		$disclaimer_text = 'BLA 081724L

		Leedwell Property Victoria Pty Ltd (ABN 58 620 496 988). The information in this email including any attachments is intended solely for the named recipient. It may contain privileged and/or confidential information. If you are not the intended recipient, you must not disclose, copy, distribute, take any action or rely upon it. If you have received this email in error, please notify the sender immediately and delete this email. It is your responsibility to scan this transmission for the presence of viruses as it cannot be guaranteed to be secure or error free. The sender does not accept liability for any error or omission in the contents of this message. Leedwell Property Victoria respects your privacy. If you no longer wish to receive marketing material and other property information from Leedwell please advise us via email to <a href="mailto:info@leedwell.com.au">info@leedwell.com.au</a> including the name of the property and/or publication that you most recently received.';
		break;
		
	case 'lam_sa':
		$disclaimer_text = 'RLA 233905

		Leedwell Asset Management Pty Ltd trading as Leedwell Asset Management (ACN 146 240 753 / ABN 81 146 240 753). The information in this email including any attachments is intended solely for the named recipient. It may contain privileged and/or confidential information. If you are not the intended recipient, you must not disclose, copy, distribute, take any action or rely upon it. If you have received this email in error, please notify the sender immediately and delete this email. It is your responsibility to scan this transmission for the presence of viruses as it cannot be guaranteed to be secure or error free. The sender does not accept liability for any error or omission in the contents of this message. Leedwell Asset Management respects your privacy. If you no longer wish to receive marketing material and other property information from Leedwell please advise us via email to <a href="mailto:info@leedwell.com.au">info@leedwell.com.au</a> including the name of the property and/or publication that you most recently received.
		
		Please read the <a href="https://www.cbs.sa.gov.au/sites/default/files/form-7-warning-notice.pdf?timestamp=1561592893776">CBS Form R7</a>. Under Legislative provisions we are required to serve this to you.';
		break;
	
	case 'lam_vic':
		$disclaimer_text = 'BLA 081724L

		Leedwell Property Victoria Pty Ltd (ABN 58 620 496 988). The information in this email including any attachments is intended solely for the named recipient. It may contain privileged and/or confidential information. If you are not the intended recipient, you must not disclose, copy, distribute, take any action or rely upon it. If you have received this email in error, please notify the sender immediately and delete this email. It is your responsibility to scan this transmission for the presence of viruses as it cannot be guaranteed to be secure or error free. The sender does not accept liability for any error or omission in the contents of this message. Leedwell Property Victoria respects your privacy. If you no longer wish to receive marketing material and other property information from Leedwell please advise us via email to <a href="mailto:info@leedwell.com.au">info@leedwell.com.au</a> including the name of the property and/or publication that you most recently received.';
		break;
}

$site_link = parse_link('https://leedwell.com.au/', 'leedwell.com.au');




?><!doctype html>
<html>

<head>
	<title>Email Signature Generator</title>
	
	<style type="text/css">
		html, input, .button, select { font: 16px/1.4 Sans-Serif; }
		
		body { padding: 20px; }
		
		h1 {
			font-size: 2rem;
			font-weight: bold;
			text-align: center;
			color: #231f20;
			margin: 0 0 1em;
		}
		
		form {
			width: 480px;
			padding: 1.5em;
			background-color: #eee;
		}
		
		form * { box-sizing: border-box; }
		
		form .wrapper {
			display: block;
			overflow: hidden;
			margin-bottom: 1em;
		}
		
		form input, form select {
			width: 100%;
			border: 2px solid gray;
			border-top: 0;
			border-radius: 0;
			padding: 0.5em 0.75em;
			margin: 0;
			
			background: none;
			outline: 0;
		}
		
		form input:focus, form textarea:focus { border-color: #231f20; }
		
		form .label {
			display: block;
			background-color: #231f20;
			padding: 0.5em;
			color: white;
		}
		
		form textarea {
			display: block;
			resize: vertical;
		}
		
		form .radio { padding: 1em 0; }
		
		form select { -webkit-appearance: none; }
		
		hr {
			margin: 2em 0;
			border: 1px solid #bebebe;
		}
		
		.button {
			font-weight: bold;
			color: #231f20;

			display: inline-block;
			padding: 0.5em 0.75em;
			border: 2px solid #231f20;

			cursor: pointer;
			background: transparent;
			transition: background 0.5s;
		}
		
		.button:not(:first-child) { margin-left: 2em; }
		
		.button:hover, .button:focus { background: white; }
		
		.instructions {
			font-size: 12px;
			padding-left: 1em;
		}
	</style>

	<script>
		document.addEventListener("DOMContentLoaded", function() {
			var copy_button = document.querySelector(".js-copy");
			
			if(copy_button != null) {
				copy_button.addEventListener("click", function() {
					var selection = document.getSelection();

					selection.removeAllRanges();
					selection.selectAllChildren(document.querySelector(".signature-wrapper"));

					document.execCommand("Copy");

					selection.empty();
				});
			}
		});
	</script>
</head>

<body>
	<form method="post">
		<h1>Email Signature Generator</h1>
		
		<label class="wrapper">
			<div class="label">Name *</div>
			
			<input type="text" name="name" required autofocus value="<?= $name ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Position</div>
			
			<input type="text" name="position" value="<?= $position ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Mobile</div>
			
			<input type="text" name="mobile" value="<?= $mobile ?>" placeholder="+61 400 000 000">
		</label>
		
		<label class="wrapper">
			<div class="label">Office</div>
			
			<select name="office">
				<option value="sa" <?php if($office == 'sa'): ?>selected<?php endif; ?>>SA</option>
				<option value="vic" <?php if($office == 'vic'): ?>selected<?php endif; ?>>VIC</option>
			</select>
		</label>
		
		<?php /*<label class="wrapper">
			<div class="label">Christmas closure message</div>
			
			<select name="close">
				<option value="show" <?php if($close == 'show'): ?>selected<?php endif; ?>>Show</option>
				<option value="hide" <?php if($close == 'hide'): ?>selected<?php endif; ?>>Hide</option>
			</select>
		</label> */ ?>
		
		<label class="wrapper">
			<div class="label">Image</div>
			
			<select name="image">
				<option value="none" <?php if($image == 'none'): ?>selected<?php endif; ?>>None</option>
				<option value="christmas" <?php if($image == 'christmas'): ?>selected<?php endif; ?>>Christmas animation</option>
				<option value="industrial" <?php if($image == 'industrial'): ?>selected<?php endif; ?>>Industrial</option>
			</select>
		</label>
		
		<label class="wrapper">
			<div class="label">Disclaimer</div>
			
			<select name="disclaimer">
				<option value="sa" <?php if($disclaimer == 'sa'): ?>selected<?php endif; ?>>SA</option>
				<option value="vic" <?php if($disclaimer == 'vic'): ?>selected<?php endif; ?>>VIC</option>
				<option value="lam_sa" <?php if($disclaimer == 'lam_sa'): ?>selected<?php endif; ?>>LAM SA</option>
				<option value="lam_vic" <?php if($disclaimer == 'lam_vic'): ?>selected<?php endif; ?>>LAM VIC</option>
			</select>
		</label>
		
		<div class="wrapper">
			<button type="submit" class="button">Generate</button>
			
			<?php if(count($_POST) > 0): ?>
				<button type="button" class="button  js-copy">Copy</button>
			<?php endif; ?>
		</div>
	</form>
	
	
	<?php if(count($_POST) > 0): ?>
		<hr>
		
		<div class="signature-wrapper">
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" width="250" style="width: 250px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;">
				<tr>
					<td style="font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 13px; border-bottom: 1px solid <?= COLOUR_GREEN ?>;">
						<strong><?= $name ?></strong>
						<?php if(strlen($position) > 0): ?><br><?= $position ?><?php endif; ?>
					</td>
				</tr>
			</table>
			
			
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" width="250" style="width: 250px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;">
				<tr>
					<td colspan="2" width="214" style="width: 37px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 13px; border-bottom: 1px solid <?= COLOUR_GREEN ?>;">
						<table role="presentation" border="0" cellpadding="0" cellspacing="0" width="214" style="width: 214px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;">
							<tr>
								<td colspan="2" style="font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-top: 13px;"></td>
							</tr>
							
							<?php if(strlen($mobile) > 0): ?>
								<tr>
									<td width="37" style="width: 37px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
										Mob
									</td>
									
									<td width="177" style="width: 177px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
										<?= parse_link('tel:' . $mobile_href, $mobile) ?>
									</td>
								</tr>
							<?php endif; ?>
							
							<tr>
								<td width="37" style="width: 37px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
									Tel
								</td>
								
								<td width="177" style="width: 177px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
									<?= $office_phone ?>
								</td>
							</tr>
							
							<?php if(strlen($office_fax) > 0): ?>
								<tr>
									<td width="37" style="width: 37px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
										Fax
									</td>
									
									<td width="177" style="width: 177px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
										<?= $office_fax ?>
									</td>
								</tr>
							<?php endif ?>
								
							<tr>
								<td colspan="1" width="37" style="width: 37px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 13px;">
									
								</td>
								
								<td colspan="1" width="177" style="width: 177px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 13px;">
									<?= $site_link ?>
								</td>
							</tr>
						</table>
					</td>
					
					<td width="36" style="width: 36px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 13px; border-bottom: 1px solid <?= COLOUR_GREEN ?>;">
						<table role="presentation" border="0" cellpadding="0" cellspacing="0" width="36" style="width: 36px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;">
							<tr>
								<td style="font-family: Arial, sans-serif; font-size: 13px; line-height: 13px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 6px; padding-top: 13px;">
									<a href="https://www.linkedin.com/company/leedwell-property/" style="display: block;">
										<img src="<?= URL_BASE ?>linkedin.png" width="16" height="auto" style="display: block; width: 16px; height: auto; border: 0; outline: none; text-decoration: none;">
									</a>
								</td>
							</tr>
							
							<tr>
								<td style="font-family: Arial, sans-serif; font-size: 13px; line-height: 13px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 6px;">
									<a href="https://www.facebook.com/leedwellproperty/" style="display: block;">
										<img src="<?= URL_BASE ?>facebook.png" width="16" height="auto" style="display: block; width: 16px; height: auto; border: 0; outline: none; text-decoration: none;">
									</a>
								</td>
							</tr>
							
							<tr>
								<td style="font-family: Arial, sans-serif; font-size: 13px; line-height: 13px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
									<a href="https://www.instagram.com/leedwellproperty/?hl=en" style="display: block;">
										<img src="<?= URL_BASE ?>instagram.png" width="16" height="auto" style="display: block; width: 16px; height: auto; border: 0; outline: none; text-decoration: none;">
									</a>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				
				<tr>
					<td width="37" style="width: 37px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-top: 13px; padding-bottom: 60px; border-top: 1px solid <?= COLOUR_GREEN ?>;">
						<?php if($office == 'sa'): ?>Adl<?php else: ?>Mel<?php endif; ?>
					</td>
					
					<td width="177" style="width: 177px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-top: 13px; padding-bottom: 60px; border-top: 1px solid <?= COLOUR_GREEN ?>;">
						<?= $office_address ?>
					</td>
					
					<td width="36" style="width: 36px; font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-top: 13px; padding-bottom: 60px; border-top: 1px solid <?= COLOUR_GREEN ?>;"></td>
				</tr>
			</table>
			
			
			
			
			<?php /* if($close == 'show'): ?>
				<table role="presentation" border="0" cellpadding="0" cellspacing="0" width="250" style="width: 250px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;">
					<tr>
						<td colspan="3" style="font-family: Arial, sans-serif; font-size: 12px; line-height: 14px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 13px;">
							<strong>We are closed from Thursday 23 December 2021 to Monday 3 January 2022, re-opening on Tuesday 4 January 2022.</strong>
						</td>
					</tr>
				</table>
			<?php endif; */ ?>
			
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" width="250" style="width: 250px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;">
				<tr>
					<td colspan="3" style="font-family: Arial, sans-serif; font-size: 13px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top;padding-bottom: 33px;">
						<img src="<?= URL_BASE ?>logo.png" width="250" style="width: 250px; max-width: 100%; border: 0; outline: none; text-decoration: none;">
					</td>
				</tr>
			</table>
			
			
			<?php if($image == 'christmas'): ?>
				<img src="<?= URL_BASE ?>christmas.gif" width="400" style="width: 400px; max-width: 100%; border: 0; outline: none; text-decoration: none; padding-bottom: 27px;">
			<?php endif; ?>
			
			<?php if($image == 'industrial'): ?>
				<a target="_blank" href="https://www.flipsnack.com/59C57A88B7A/leedwell-industrial-market-overview-first-half-2021-2022/full-view.html">
					<img src="<?= URL_BASE ?>industrial.png" width="400" style="width: 400px; max-width: 100%; border: 0; outline: none; text-decoration: none; padding-bottom: 27px;">
				</a>
			<?php endif; ?>
			
			
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" width="400" style="width: 400px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;">
				<tr>
					<td style="font-family: Arial, sans-serif; font-size: 8px; line-height: 10px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 20px;">
						<?= nl2br($disclaimer_text) ?>
					</td>
				</tr>
			</table>
		</div>
	<?php endif; ?>
</body>

</html>
