<?php

define('URL_BASE', 'https://secure.simple.com.au/clients/dominant/');

define('COLOUR_WHITE', '#FFFFFF');
define('COLOUR_BLACK', '#232526');
define('COLOUR_BLUE', '#2526A9');
define('COLOUR_GREY', '#D1D4D3');


define(LINK_STYLE, 'color: ' . COLOUR_BLACK . '; text-decoration: none;');


function parse_link($url, $text) {
	?><a href="<?= $url ?>" style="<?= LINK_STYLE ?>"><span style="<?= LINK_STYLE ?>"><font style="<?= LINK_STYLE ?>"><?= $text ?></font></span></a><?php ;
}

function get_param($label) { return isset($_REQUEST[$label]) ? $_REQUEST[$label] : ''; }



$name = get_param('name');
$position = get_param('position');


$location = get_param('location');

$location_html = '12 Coglin Street<br>Brompton SA 5007<br>Australia';
if($location == 'vic') $location_html = '21 Stubbs Street<br>Kensington VIC 3031<br>Australia';
if($location == 'qld') $location_html = 'Unit 4/2 Tombo Street<br>Capalaba QLD 4157<br>Australia';

$mobile = get_param('mobile');
$phone = get_param('phone');


if(strlen($phone) > 0) {
	$phone_href = 'tel:+' . preg_replace('~\D~', '', $phone);
}

if(strlen($mobile) > 0) {
	$mobile_href = 'tel:+' . preg_replace('~\D~', '', $mobile);
}





?><!doctype html>
<html>

<head>
	<title>Email Signature Generator</title>
	
	<style type="text/css">
		html, input, .button, select { font: 16px/1.4 Sans-Serif; }
		
		body { padding: 20px; }
		
		h1 {
			font-size: 2rem;
			font-weight: bold;
			text-align: center;
			color: #231f20;
			margin: 0 0 1em;
		}
		
		form {
			width: 480px;
			padding: 1.5em;
			background-color: #eee;
		}
		
		form * { box-sizing: border-box; }
		
		form .wrapper {
			display: block;
			overflow: hidden;
			margin-bottom: 1em;
		}
		
		form input, form select {
			width: 100%;
			border: 2px solid gray;
			border-top: 0;
			border-radius: 0;
			padding: 0.5em 0.75em;
			margin: 0;
			
			background: none;
			outline: 0;
		}
		
		form input:focus, form textarea:focus { border-color: #231f20; }
		
		form .label {
			display: block;
			background-color: #231f20;
			padding: 0.5em;
			color: white;
		}
		
		form textarea {
			display: block;
			resize: vertical;
		}
		
		form .radio { padding: 1em 0; }
		
		form select { -webkit-appearance: none; }
		
		hr {
			margin: 2em 0;
			border: 1px solid #bebebe;
		}
		
		.button {
			font-weight: bold;
			color: #231f20;

			display: inline-block;
			padding: 0.5em 0.75em;
			border: 2px solid #231f20;

			cursor: pointer;
			background: transparent;
			transition: background 0.5s;
		}
		
		.button:not(:first-child) { margin-left: 2em; }
		
		.button:hover, .button:focus { background: white; }
		
		.instructions {
			font-size: 12px;
			padding-left: 1em;
		}
	</style>

	<script>
		document.addEventListener("DOMContentLoaded", function() {
			var copy_button = document.querySelector(".js-copy");
			
			if(copy_button != null) {
				copy_button.addEventListener("click", function() {
					var selection = document.getSelection();

					selection.removeAllRanges();
					selection.selectAllChildren(document.querySelector(".signature-wrapper"));

					document.execCommand("Copy");

					selection.empty();
				});
			}
		});
	</script>
</head>

<body>
	<form method="post">
		<h1>Email Signature Generator</h1>
		
		<label class="wrapper">
			<div class="label">Name *</div>
			
			<input type="text" name="name" required autofocus value="<?= $name ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Position *</div>
			
			<input type="text" name="position" required value="<?= $position ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Location *</div>
			
			<select name="location" required>
				<option value="sa" <?php if($location == 'sa'): ?>selected<?php endif; ?>>South Australia</option>
				<option value="vic" <?php if($location == 'vic'): ?>selected<?php endif; ?>>Victoria</option>
				<option value="qld" <?php if($location == 'qld'): ?>selected<?php endif; ?>>Queensland</option>
			</select>
		</label>
		
		<label class="wrapper">
			<div class="label">Mobile (syntax: +61 400 000 000)</div>
			
			<input type="text" name="mobile" value="<?= $mobile ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Phone (syntax: +61 8 8000 0000)</div>
			
			<input type="text" name="phone" value="<?= $phone ?>">
		</label>
		
		<div class="wrapper">
			<button type="submit" class="button">Generate</button>
			
			<?php if(count($_POST) > 0): ?>
				<button type="button" class="button  js-copy">Copy</button>
			<?php endif; ?>
		</div>
	</form>
	
	
	<?php if(count($_POST) > 0): ?>
		<hr>
		
		<div class="signature-wrapper">
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" width="320" style="width: 320px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;">
				<tr>
					<td colspan="3" style="font-family: Arial, sans-serif; font-size: 15px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 20px;">
						<strong style="color: <?= COLOUR_BLUE ?>;"><?= $name ?></strong><br>
						<?= $position ?>
					</td>
				</tr>
				
				
				<tr>
					<td colspan="1" width="175" style="width: 175px; font-family: Arial, sans-serif; font-size: 15px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; border-right: 1px solid  <?= COLOUR_GREY ?>;">
						<?php if(strlen($mobile) > 0): ?>Mob.&nbsp;&nbsp;&nbsp;<?php parse_link($mobile_href, $mobile) ?><br><?php endif; ?>
						
						<?php if(strlen($phone) > 0): ?>Tel.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php parse_link($phone_href, $phone) ?><br><?php endif; ?>
						
						Web.&nbsp;&nbsp;&nbsp;<?php parse_link('https://dominant.com.au/', 'dominant.com.au') ?>
					</td>
					
					<td colspan="1" width="10" style="width: 10px"></td>
					
					<td colspan="1" width="134" style="width: 134px; font-family: Arial, sans-serif; font-size: 15px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
						<?= $location_html ?>
					</td>
				</tr>
				
				
				<tr>
					<td colspan="3" style="font-family: Arial, sans-serif; font-size: 15px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 32px;"></td>
				</tr>
				
				
				<tr>
					<td colspan="1" width="175" style="width: 175px; font-family: Arial, sans-serif; font-size: 15px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; border-right: 1px solid  <?= COLOUR_GREY ?>;">
						<img src="<?= URL_BASE ?>logo.png" width="116" height="auto" style="width: 116px; height: auto; border: 0; outline: none; text-decoration: none;">
					</td>
					
					<td colspan="1" width="10" style="width: 10px"></td>
					
					<td colspan="1" width="134" style="width: 134px; font-family: Arial, sans-serif; font-size: 15px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
						<a href="http://www.linkedin.com/company/2717229" target="_blank"><img src="<?= URL_BASE ?>linkedIn.png" width="22" height="auto" style="width: 22px; height: auto; border: 0; outline: none; text-decoration: none;"></a>
					</td>
				</tr>
				
				
				<tr>
					<td colspan="3" style="font-family: Arial, sans-serif; font-size: 15px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 32px;"></td>
				</tr>
			</table>
		</div>
	<?php endif; ?>
</body>

</html>
