<?php

define('URL_BASE', 'https://secure.simple.com.au/clients/coherics/');

define('COLOUR_WHITE', '#FFFFFF');
define('COLOUR_BLACK', '#232526');
define('COLOUR_BLUE', '#00162D');
define('COLOUR_GREY', '#D1D4D3');


define(LINK_STYLE, 'color: ' . COLOUR_BLACK . '; text-decoration: none;');


function parse_link($url, $text) {
	?><a href="<?= $url ?>" style="<?= LINK_STYLE ?>"><span style="<?= LINK_STYLE ?>"><font style="<?= LINK_STYLE ?>"><?= $text ?></font></span></a><?php ;
}

function get_param($label) { return isset($_REQUEST[$label]) ? $_REQUEST[$label] : ''; }



$name = get_param('name');
$qualification = get_param('qualification');
$role = get_param('role');
$mobile = get_param('mobile');
$phone = "08 7444 5073";
$email = get_param('email');

if(strlen($mobile) > 0) {
	$mobile_href = 'tel:+' . preg_replace('~\D~', '', $mobile);
}
if(strlen($phone) > 0) {
	$phone_href = 'tel:+' . preg_replace('~\D~', '', $phone);
}




?><!doctype html>
<html>

<head>
	<title>Email Signature Generator</title>
	
	<style type="text/css">
		html, input, .button, select { font: 16px/1.4 Sans-Serif; }
		
		body { padding: 20px; }
		
		h1 {
			font-size: 2rem;
			font-weight: bold;
			text-align: center;
			color: #231f20;
			margin: 0 0 1em;
		}
		
		form {
			width: 480px;
			padding: 1.5em;
			background-color: #eee;
		}
		
		form * { box-sizing: border-box; }
		
		form .wrapper {
			display: block;
			overflow: hidden;
			margin-bottom: 1em;
		}
		
		form input, form select {
			width: 100%;
			border: 2px solid gray;
			border-top: 0;
			border-radius: 0;
			padding: 0.5em 0.75em;
			margin: 0;
			
			background: none;
			outline: 0;
		}
		
		form input:focus, form textarea:focus { border-color: #231f20; }
		
		form .label {
			display: block;
			background-color: #231f20;
			padding: 0.5em;
			color: white;
		}
		
		form textarea {
			display: block;
			resize: vertical;
		}
		
		form .radio { padding: 1em 0; }
		
		form select { -webkit-appearance: none; }
		
		hr {
			margin: 2em 0;
			border: 1px solid #bebebe;
		}
		
		.button {
			font-weight: bold;
			color: #231f20;

			display: inline-block;
			padding: 0.5em 0.75em;
			border: 2px solid #231f20;

			cursor: pointer;
			background: transparent;
			transition: background 0.5s;
		}
		
		.button:not(:first-child) { margin-left: 2em; }
		
		.button:hover, .button:focus { background: white; }
		
		.instructions {
			font-size: 12px;
			padding-left: 1em;
		}
	</style>

	<script>
		document.addEventListener("DOMContentLoaded", function() {
			var copy_button = document.querySelector(".js-copy");
			
			if(copy_button != null) {
				copy_button.addEventListener("click", function() {
					var selection = document.getSelection();

					selection.removeAllRanges();
					selection.selectAllChildren(document.querySelector(".signature-wrapper"));

					document.execCommand("Copy");

					selection.empty();
				});
			}
		});
	</script>
</head>

<body>
	<form method="post">
		<h1>Email Signature Generator</h1>
		
		<label class="wrapper">
			<div class="label">Name *</div>
			<input type="text" name="name" required autofocus value="<?= $name ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Qualification *</div>
			<input type="text" name="qualification" required value="<?= $qualification ?>">
		</label>
		<label class="wrapper">
			<div class="label">Role *</div>
			<input type="text" name="role" required value="<?= $role ?>">
		</label>
		<label class="wrapper">
			<div class="label">Mobile (syntax: +61 400 000 000)</div>
			<input type="text" name="mobile" value="<?= $mobile ?>">
		</label>
		<label class="wrapper">
			<div class="label">Email </div>
			<input type="text" name="email" value="<?= $email ?>">
		</label>
		
		<div class="wrapper">
			<button type="submit" class="button">Generate</button>
			
			<?php if(count($_POST) > 0): ?>
				<button type="button" class="button  js-copy">Copy</button>
			<?php endif; ?>
		</div>
	</form>
	
	
	<?php if(count($_POST) > 0): ?>
		<hr>
		
		<div class="signature-wrapper">
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" width="650" style="width: 650px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;">
				<tr>
					<td colspan="2" style="font-family: Arial, sans-serif; font-size: 14px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 20px;">
						<strong style="color: <?= COLOUR_BLUE ?>;"><?= $name ?></strong> | <?= $qualification ?> <br>
						<?= $role ?>
					</td>
				</tr>
				
				
				<tr>
					<td colspan="1" width="200" style="width: 200px; font-family: Arial, sans-serif; font-size: 14px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; border-right: 1px solid  <?= COLOUR_GREY ?>;">
						217 Flinders Street, Adelaide<br />
            			South Australia<br />
						<a href="http://www.linkedin.com/company/coherics" style="text-decoration:underline;color: <?= COLOUR_BLACK ?>;" target="_blank">LinkedIn</a>
					</td>
					<td colspan="1" width="360" style="width: 360px; padding-left:30px; font-family: Arial, sans-serif; font-size: 14px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
						<?php if(strlen($mobile) > 0): ?>M&nbsp;<?php parse_link($mobile_href, $mobile) ?><?php endif; ?> | <?php if(strlen($phone) > 0): ?>T&nbsp;<?php parse_link($phone_href, $phone) ?><?php endif; ?>
						<br />
						<?php if(strlen($email) > 0): ?><a href="mailto:<?= $email ?>" style="color: <?= COLOUR_BLACK ?>;text-decoration:none;"><?= $email ?></a><br><?php endif; ?>
						<?php parse_link('https://coherics.com.au/', 'coherics.com.au') ?>
					</td>
					 
				</tr>
				
				
				<tr>
					<td colspan="3" style="font-family: Arial, sans-serif; font-size: 14px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 32px;"></td>
				</tr>
				
				
				<tr>
					<td colspan="2" width="200" style="width: 200px; font-family: Arial, sans-serif; font-size: 14px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
						<img src="<?= URL_BASE ?>logo.png" width="200" height="auto" style="width: 200px; height: auto; border: 0; outline: none; text-decoration: none;">
					</td>
				</tr>
				<tr>
					<td colspan="3" style="font-family: Arial, sans-serif; font-size: 14px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 32px;"></td>
				</tr>
				 <tr>
					<td colspan="2" width="200" style="width: 200px; font-family: Arial, sans-serif; font-size: 14px; line-height: 20px; color: <?= COLOUR_BLUE ?>; font-style: italic; vertical-align: top;">
					Every action assessed<br />
					Every mission mastered
					</td>
				</tr>
				<tr>
					<td colspan="3" style="font-family: Arial, sans-serif; font-size: 14px; line-height: 20px; color: <?= COLOUR_BLACK ?>; vertical-align: top; padding-bottom: 32px;"></td>
				</tr>
				 <tr>
					<td colspan="2" width="420" style="width: 420px; font-family: Arial, sans-serif; font-size: 10px; line-height: 12px; color: <?= COLOUR_BLACK ?>; vertical-align: top;">
					This email and any files transmitted with it are confidential and intended solely for the use of the individual or entity to whom they are addressed. If you have received this email in error, please notify the sender immediately. As this email is confidential and if you are not the named addressee, you are not permitted not disseminate, distribute or copy this email. Please delete this email if you have received this email by mistake.
					</td>
				</tr>
			
			</table>
		</div>
	<?php endif; ?>
</body>

</html>
