<?php

define(LINK_STYLE, 'color: #604546; text-decoration: underline;');


function parse_link($url, $text) {
	?><a href="<?= $url ?>" style="<?= LINK_STYLE ?>"><span style="<?= LINK_STYLE ?>"><font style="<?= LINK_STYLE ?>"><?= $text ?></font></span></a><?php ;
}


$URL_BASE = 'https://secure.simple.com.au/clients/bund/';

function getParam($label) { return isset($_REQUEST[$label]) ? $_REQUEST[$label] : ''; }

$name = getParam('name');
$position = getParam('position');
$phone = getParam('phone');
$email = getParam('email');

if(strlen($phone) > 0) $phone_href = preg_replace('~\D~', '', $phone);



?><!doctype html>
<html>

<head>
	<title>Email Signature Generator</title>
	
	<style type="text/css">
		html, input, .button, select { font: 16px/1.4 Sans-Serif; }
		
		body { padding: 20px; }
		
		h1 {
			font-size: 2rem;
			font-weight: bold;
			text-align: center;
			color: #231f20;
			margin: 0 0 1em;
		}
		
		form {
			width: 480px;
			padding: 1.5em;
			background-color: #eee;
		}
		
		form * { box-sizing: border-box; }
		
		form .wrapper {
			display: block;
			overflow: hidden;
			margin-bottom: 1em;
		}
		
		form input, form select {
			width: 100%;
			border: 2px solid gray;
			border-top: 0;
			border-radius: 0;
			padding: 0.5em 0.75em;
			margin: 0;
			
			background: none;
			outline: 0;
		}
		
		form input:focus, form textarea:focus { border-color: #231f20; }
		
		form .label {
			display: block;
			background-color: #231f20;
			padding: 0.5em;
			color: white;
		}
		
		form textarea {
			display: block;
			resize: vertical;
		}
		
		form .radio { padding: 1em 0; }
		
		form select { -webkit-appearance: none; }
		
		hr {
			margin: 2em 0;
			border: 1px solid #bebebe;
		}
		
		.button {
			font-weight: bold;
			color: #231f20;

			display: inline-block;
			padding: 0.5em 0.75em;
			border: 2px solid #231f20;

			cursor: pointer;
			background: transparent;
			transition: background 0.5s;
		}
		
		.button:not(:first-child) { margin-left: 2em; }
		
		.button:hover, .button:focus { background: white; }
		
		.instructions {
			font-size: 12px;
			padding-left: 1em;
		}
	</style>

	<script>
		document.addEventListener("DOMContentLoaded", function() {
			var copy_button = document.querySelector(".js-copy");
			
			if(copy_button != null) {
				copy_button.addEventListener("click", function() {
					var selection = document.getSelection();

					selection.removeAllRanges();
					selection.selectAllChildren(document.querySelector(".signature-wrapper"));

					document.execCommand("Copy");

					selection.empty();
				});
			}
		});
	</script>
</head>

<body>
	<form method="post">
		<h1>Email Signature Generator</h1>
		
		<label class="wrapper">
			<div class="label">Name *</div>
			
			<input type="text" name="name" required autofocus value="<?= $name ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Position *</div>
			
			<input type="text" name="position" required value="<?= $position ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Phone *</div>
			
			<input type="text" name="phone" required value="<?= $phone ?>" placeholder="0400 000 000">
		</label>
		
		<label class="wrapper">
			<div class="label">Email *</div>
			
			<input type="email" name="email" required value="<?= $email ?>">
		</label>
		
		<div class="wrapper">
			<button type="submit" class="button">Generate</button>
			
			<?php if(count($_POST) > 0): ?>
				<button type="button" class="button  js-copy">Copy</button>
			<?php endif; ?>
		</div>
	</form>
	
	
	<?php if(count($_POST) > 0): ?>
		<hr>
		
		<div class="signature-wrapper">
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" style="width: 540px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;" width="540px">
				<tr>
					<td style="font-family: Arial, sans-serif; font-size: 14px; line-height: 21px; color: #928383; vertical-align: top; padding-top: 21px; padding-bottom: 21px; border-top: 1px solid #f3ac9b; border-bottom: 1px solid #f3ac9b">
						<span style="color: #604546"><?= $name ?></span><br>
						<?= $position ?><br>
						<?= parse_link('tel:' . $phone_href, $phone); ?><br>
						<?= parse_link('mailto:' . $email, $email); ?>
					</td>
				</tr>
				
				<tr>
					<td style="font-family: Arial, sans-serif; font-size: 14px; line-height: 21px; color: #928383; vertical-align: top; padding-top: 21px; padding-bottom: 21px;">
						185 Grote Street, Adelaide SA<br>
						GPO Box 651 Adelaide SA 5001<br>
						<?= parse_link('https://equipeadvisory.com.au', 'equipeadvisory.com.au'); ?><br>
						<br>
						<br>
						<br>
						<img src="<?= $URL_BASE ?>logo.png" style="width: 440x; border: 0; outline: none; text-decoration: none; height: auto;" width="440" height="auto">
						<br>
						<br>
						<br>
						<br>
						<br>
						<br>
						Liability limited by a scheme approved under Professional Standards Legislation.<br>
						<br>
						<span style="font-size: 12px; line-height: 18px;">NOTICE - The information in this email and any attachment(s) is confidential and intended for the named recipient/s only. If you are not the intended recipient, you must not use, disclose, read, forward, copy or retain any of the information. If this e-mail is received in error, please delete it and notify the sender by return e-mail or telephone. Neither Equipe Advisory nor the sender accepts any responsibility for any viruses or any other harmful software that may be contained in this e-mail or its attachments. It is your responsibility to establish your own protection against viruses or any other harmful software.</span><br>
						<br>
						Think before you print. All the little things add up.
					</td>
				</tr>
			</table>
		</div>
	<?php endif; ?>
</body>

</html>
