<?php

$URL_BASE = 'https://secure.simple.com.au/clients/allan/';

function getParam($label) { return isset($_REQUEST[$label]) ? $_REQUEST[$label] : ''; }

$variant = getParam('variant');

$name = getParam('name');
$position = getParam('position');

$mobile = getParam('mobile');
$email = getParam('email');
$address = getParam('address');


if(strlen($mobile) > 0) $mobile_href = '+61' . preg_replace('~^0~', '', preg_replace('~\D~', '', $mobile));

if(strlen($address) == 0) $address = '609 Anzac Highway Glenelg North SA 5045';


?><!doctype html>
<html>

<head>
	<title>Email Signature Generator</title>
	
	<style type="text/css">
		html, input, .button, select { font: 16px/1.4 Sans-Serif; }
		
		body { padding: 20px; }
		
		h1 {
			font-size: 2rem;
			font-weight: bold;
			text-align: center;
			color: #231f20;
			margin: 0 0 1em;
		}
		
		form {
			width: 480px;
			padding: 1.5em;
			background-color: #eee;
		}
		
		form * { box-sizing: border-box; }
		
		form .wrapper {
			display: block;
			overflow: hidden;
			margin-bottom: 1em;
		}
		
		form input, form select {
			width: 100%;
			border: 2px solid gray;
			border-top: 0;
			border-radius: 0;
			padding: 0.5em 0.75em;
			margin: 0;
			
			background: none;
			outline: 0;
		}
		
		form input:focus, form textarea:focus { border-color: #231f20; }
		
		form .label {
			display: block;
			background-color: #231f20;
			padding: 0.5em;
			color: white;
		}
		
		form textarea {
			display: block;
			resize: vertical;
		}
		
		form .radio { padding: 1em 0; }
		
		form select { -webkit-appearance: none; }
		
		hr {
			margin: 2em 0;
			border: 1px solid #bebebe;
		}
		
		.button {
			font-weight: bold;
			color: #231f20;

			display: inline-block;
			padding: 0.5em 0.75em;
			border: 2px solid #231f20;

			cursor: pointer;
			background: transparent;
			transition: background 0.5s;
		}
		
		.button:not(:first-child) { margin-left: 2em; }
		
		.button:hover, .button:focus { background: white; }
		
		.instructions {
			font-size: 12px;
			padding-left: 1em;
		}
	</style>

	<script>
		document.addEventListener("DOMContentLoaded", function() {
			var copy_button = document.querySelector(".js-copy");
			
			if(copy_button != null) {
				copy_button.addEventListener("click", function() {
					var selection = document.getSelection();

					selection.removeAllRanges();
					selection.selectAllChildren(document.querySelector(".signature-wrapper"));

					document.execCommand("Copy");

					selection.empty();
				});
			}
		});
	</script>
</head>

<body>
	
	
	<form method="post">
		<h1>Email Signature Generator</h1>
		
		<label class="wrapper">
			<div class="label">Name *</div>
			
			<input type="text" name="name" required autofocus value="<?= $name ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Position *</div>
			
			<input type="text" name="position" required value="<?= $position ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Mobile</div>
			
			<input type="text" name="mobile" value="<?= $mobile ?>" placeholder="04xx xxx xxx">
		</label>
		
		<label class="wrapper">
			<div class="label">Email *</div>
			
			<input type="email" name="email" required value="<?= $email ?>">
		</label>
		
		<label class="wrapper">
			<div class="label">Address *</div>
			
			<input type="text" name="address" required value="<?= $address ?>">
		</label>
		
		<div class="wrapper">
			<button type="submit" class="button">Generate</button>
			
			<?php if(count($_POST) > 0): ?>
				<button type="button" class="button  js-copy">Copy</button>
			<?php endif; ?>
		</div>
	</form>
	
	
	<?php if(count($_POST) > 0): ?>
		<hr>
		
		<div class="signature-wrapper">
			<table role="presentation" border="0" cellpadding="0" cellspacing="0" style="width: 300px; font-feature-set: kern, liga, pnum; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; text-rendering: optimizeLegibility;" width="300">
				<tr>
					<td colspan="5" style="font-family: Arial; font-size: 14px; line-height: 1.2; color: #58585a; vertical-align: top; padding-bottom: 28px;">
						<span style="color: #58585a; text-decoration: none; font-weight: bold;"><font style="color: #58585a; text-decoration: none; font-weight: bold;"><?= $name ?></font></span><br>
						
						<span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;"><?= $position ?></font></span><br>
						
						<br>
						<br>
						
						<?php if(strlen($mobile) > 0): ?>
							<span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;"><?= $mobile ?></font></span><br>
						<?php endif; ?>

						<a href="mailto:<?= $email ?>" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;"><?= $email ?></font></span></a><br>
						
						<span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;"><?= $address ?></font></span><br>

						<span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">08 7120 7299</font></span><br>
						
					</td>
				</tr>
				
				
				<tr>
					<td style="font-family: Arial; font-size: 14px; line-height: 20px; color: #58585a; vertical-align: top; width: 32px; padding-bottom: 28px;">
						<a href="https://www.facebook.com/AllanRealEstateSA" target="_blank" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">
							<img src="<?= $URL_BASE ?>facebook.png" style="width: 19x; border: 0; outline: none; text-decoration: none; height: auto;" width="19" height="auto">
						</font></span></a>
					</td>
					
					<td style="font-family: Arial; font-size: 14px; line-height: 20px; color: #58585a; vertical-align: top; width: 32px; padding-bottom: 28px;">
						<a href="https://www.instagram.com/allan_real_estate/" target="_blank" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">
							<img src="<?= $URL_BASE ?>instagram.png" style="width: 20px; border: 0; outline: none; text-decoration: none; height: auto;" width="20" height="auto">
						</font></span></a>
					</td>
					
					<td style="font-family: Arial; font-size: 14px; line-height: 20px; color: #58585a; vertical-align: top; width: 64px; padding-bottom: 28px;">
						<a href="https://www.youtube.com/channel/UCYVscGdt_5pYLvq3UrM6gcA" target="_blank" style="color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">
							<img src="<?= $URL_BASE ?>youtube.png" style="width: 25px; border: 0; outline: none; text-decoration: none; height: auto;" width="25" height="auto">
						</font></span></a>
					</td>
				</tr>
				
				
				
				<tr>
					<td colspan="5" style="font-family: Arial; font-size: 14px; line-height: 1.2; color: #58585a; vertical-align: top; padding-bottom: 28px;">
						<a href="https://www.allanre.com.au" target="_blank" style="border-bottom: 1px solid #404040; padding-bottom: 10px; color: #58585a; text-decoration: none;"><span style="color: #58585a; text-decoration: none;"><font style="color: #58585a; text-decoration: none;">
							
							<img src="<?= $URL_BASE ?>logo.png" style="width: 300px; border: 0; outline: none; text-decoration: none; height: auto;" width="300" height="auto">
							
						</font></span></a>
					
					</td>
				</tr>
				
				
				<tr>
					<td colspan="5" style="font-family: Arial; font-size: 11px; line-height: 1.2; color: #969696; vertical-align: top; padding-bottom: 28px;">
						<div style="color: #969696; text-decoration: none; width: 300px;"><font style="color: #969696; text-decoration: none;">	The contents of this e-mail are confidential and may be subject to privilege and copyright. This e-mail is intended for the named recipient only and if you have received this e-mail in error please notify Allan Real Estate and delete the material from any system and destroy any copies.<br><br><strong>Allan Real Estate | RLA 239101</strong></font></div>
					</td>
				</tr>
			</table>
		</div>
	<?php endif; ?>
</body>

</html>
