<!doctype html>
<html>
<head>

<title>A. W. Vater - Email Signature Generator</title>

<style>
form section {
	display: flex;
}

fieldset {
	display: block;
	padding: 0;
	border: 0;
	margin: 0;
	margin-bottom: 32px;
}

fieldset:not(:first-child) { margin-left: 4rem; }

h2 { margin-bottom: 0.25em; }

input {
	padding: 0.5em;
	border: 1px solid black;
}

button {
	display: block;
	padding: 1em;
	border: 2px solid black;
	margin-top: 2rem;
	cursor: pointer;
	background: white;
	transition: background 0.6s;
}

button:hover, button:focus { background: lightgrey; }

hr { margin: 50px 0; }

</style>
</head>

<body>


<?php
function hasData($param) { return (isset($_POST[$param]) && !empty($_POST[$param])); }
function setValue($param) { return hasData($param) ? " value=\"" . $_POST[$param] . "\"" : ""; }

$nameValue = setValue("name");
$name = hasData("name") ? $_POST["name"] : "[Name goes here]";

$positionValue = setValue("position");
$position = hasData("position") ? $_POST["position"] : "[Position goes here]";


$locumValue = setValue("locum");
$locum = hasData("locum") ? $_POST["locum"] : "[Location goes here]";

$streetValue = setValue("street");
$street = hasData("street") ? $_POST["street"] : "[Street goes here]";

$stateValue = setValue("state");
$state = hasData("state") ? $_POST["state"] : "[State goes here]";


$mobileValue = setValue("mobile");
$mobile = hasData("mobile") ? $_POST["mobile"] : "[Mobile #]";

$phoneValue = setValue("phone");
$phone = hasData("phone") ? $_POST["phone"] : "[Phone #]";


?>


<form method="post">
	<section>
		<fieldset>
			<label>
				<h2>Name</h2>
				<input type="text" name="name" placeholder="Roger Vater"<?= $nameValue ?>>
			</label>
			
			<label>
				<h2>Position</h2>
				<input type="text" name="position" placeholder="Dealer Principal"<?= $positionValue ?>>
			</label>
		</fieldset>
		
		
		<fieldset>
			<label>
				<h2>Location</h2>
				<input type="text" name="locum" placeholder="Head Office"<?= $locumValue ?>>
			</label>
			
			<label>
				<h2>Street Addresss</h2>
				<input type="text" name="street" placeholder="1248 Saddleworth Road"<?= $streetValue ?>>
			</label>
			
			<label>
				<h2>Suburb/State/Postcode</h2>
				<input type="text" name="state" placeholder="Saddleworth SA 5413"<?= $stateValue ?>>
			</label>
		</fieldset>
		
		
		<fieldset>
			<label>
				<h2>Mobile Number</h2>
				<input type="text" name="mobile" placeholder="0447 880 000"<?= $mobileValue ?>>
			</label>
			
			<label>
				<h2>Telephone Number</h2>
				<input type="text" name="phone" placeholder="(08) 8847 5000"<?= $phoneValue ?>>
			</label>
		</fieldset>
	</section>
	
	<button type="submit">Submit</button>
</form>


<hr>


<p style="font-family: Arial; font-size: 16px; line-height: 24px; color: #091433; margin-top: 0; margin-bottom: 24px;">
	<?= $name ?><br>
	<?= $position ?>
</p>

<table cellpadding="0" cellspacing="0" border="0" style="padding: 0; vertical-align: top; text-align: left;">
	<tbody>
		<tr style="padding: 0; vertical-align: top; text-align: left">
			<td style="padding: 0; vertical-align: top; text-align: left;">
				<p style="font-family: Arial; font-size: 16px; line-height: 24px; color: #818d96; margin-top: 0; margin-bottom: 24px;">
					<?= $locum ?><br>
					<?= $street ?><br>
					<?= $state ?>
				</p>
			</td>
			
			<td style="padding: 0; vertical-align: top; text-align: left; padding-left: 48px;">
				<p style="font-family: Arial; font-size: 16px; line-height: 24px; color: #818d96; margin-top: 0; margin-bottom: 24px;">
					M <?= $mobile ?><br>
					T <?= $phone ?><br>
					vater.com.au
				</p>
			</td>
		</tr>
	</tbody>
</table>

<img src="logo.png">

<p style="font-family: Arial; font-size: 16px; line-height: 24px; color: #091433; margin-top: 20px; margin-bottom: 24px;">
	&lsquo;Vater leaves a lasting impression&rsquo;
</p>


</body>

</html>